package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  HubDisplayName,
  HubDescription,
  HubName
}
import scala.jdk.CollectionConverters.*
final case class CreateHubRequest(
    hubName: HubName,
    hubDescription: HubDescription,
    hubDisplayName: Optional[HubDisplayName] = Optional.Absent,
    hubSearchKeywords: Optional[Iterable[HubSearchKeyword]] = Optional.Absent,
    s3StorageConfig: Optional[zio.aws.sagemaker.model.HubS3StorageConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateHubRequest = {
    import CreateHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateHubRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubDescription(HubDescription.unwrap(hubDescription): java.lang.String)
      .optionallyWith(
        hubDisplayName.map(value =>
          HubDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubDisplayName)
      .optionallyWith(
        hubSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubSearchKeywords)
      .optionallyWith(s3StorageConfig.map(value => value.buildAwsValue()))(
        _.s3StorageConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateHubRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateHubRequest.wrap(buildAwsValue())
}
object CreateHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateHubRequest =
      zio.aws.sagemaker.model.CreateHubRequest(
        hubName,
        hubDescription,
        hubDisplayName.map(value => value),
        hubSearchKeywords.map(value => value),
        s3StorageConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hubName: HubName
    def hubDescription: HubDescription
    def hubDisplayName: Optional[HubDisplayName]
    def hubSearchKeywords: Optional[List[HubSearchKeyword]]
    def s3StorageConfig
        : Optional[zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubDescription: ZIO[Any, Nothing, HubDescription] =
      ZIO.succeed(hubDescription)
    def getHubDisplayName: ZIO[Any, AwsError, HubDisplayName] =
      AwsError.unwrapOptionField("hubDisplayName", hubDisplayName)
    def getHubSearchKeywords: ZIO[Any, AwsError, List[HubSearchKeyword]] =
      AwsError.unwrapOptionField("hubSearchKeywords", hubSearchKeywords)
    def getS3StorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3StorageConfig", s3StorageConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHubRequest
  ) extends zio.aws.sagemaker.model.CreateHubRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubDescription: HubDescription =
      zio.aws.sagemaker.model.primitives.HubDescription(impl.hubDescription())
    override val hubDisplayName: Optional[HubDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.HubDisplayName(value))
    override val hubSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val s3StorageConfig
        : Optional[zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageConfig())
        .map(value => zio.aws.sagemaker.model.HubS3StorageConfig.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHubRequest
  ): zio.aws.sagemaker.model.CreateHubRequest.ReadOnly = new Wrapper(impl)
}
