package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class CreateEdgeDeploymentStageRequest(
    edgeDeploymentPlanName: EntityName,
    stages: Iterable[zio.aws.sagemaker.model.DeploymentStage]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest = {
    import CreateEdgeDeploymentStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest
      .wrap(buildAwsValue())
}
object CreateEdgeDeploymentStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest =
      zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest(
        edgeDeploymentPlanName,
        stages.map { item =>
          item.asEditable
        }
      )
    def edgeDeploymentPlanName: EntityName
    def stages: List[zio.aws.sagemaker.model.DeploymentStage.ReadOnly]
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getStages: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DeploymentStage.ReadOnly
    ]] = ZIO.succeed(stages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest
  ) extends zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val stages
        : List[zio.aws.sagemaker.model.DeploymentStage.ReadOnly] = impl
      .stages()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.DeploymentStage.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest
  ): zio.aws.sagemaker.model.CreateEdgeDeploymentStageRequest.ReadOnly =
    new Wrapper(impl)
}
