package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoMLProblemTypeResolvedAttributes(
    tabularResolvedAttributes: Optional[
      zio.aws.sagemaker.model.TabularResolvedAttributes
    ] = Optional.Absent,
    textGenerationResolvedAttributes: Optional[
      zio.aws.sagemaker.model.TextGenerationResolvedAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes = {
    import AutoMLProblemTypeResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes
      .builder()
      .optionallyWith(
        tabularResolvedAttributes.map(value => value.buildAwsValue())
      )(_.tabularResolvedAttributes)
      .optionallyWith(
        textGenerationResolvedAttributes.map(value => value.buildAwsValue())
      )(_.textGenerationResolvedAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes
      .wrap(buildAwsValue())
}
object AutoMLProblemTypeResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes =
      zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes(
        tabularResolvedAttributes.map(value => value.asEditable),
        textGenerationResolvedAttributes.map(value => value.asEditable)
      )
    def tabularResolvedAttributes
        : Optional[zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly]
    def textGenerationResolvedAttributes: Optional[
      zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly
    ]
    def getTabularResolvedAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tabularResolvedAttributes",
      tabularResolvedAttributes
    )
    def getTextGenerationResolvedAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "textGenerationResolvedAttributes",
      textGenerationResolvedAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes
  ) extends zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly {
    override val tabularResolvedAttributes
        : Optional[zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tabularResolvedAttributes())
        .map(value =>
          zio.aws.sagemaker.model.TabularResolvedAttributes.wrap(value)
        )
    override val textGenerationResolvedAttributes: Optional[
      zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.textGenerationResolvedAttributes())
      .map(value =>
        zio.aws.sagemaker.model.TextGenerationResolvedAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes
  ): zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly =
    new Wrapper(impl)
}
