package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SnsTopicArn
import scala.jdk.CollectionConverters.*
final case class AsyncInferenceNotificationConfig(
    successTopic: Optional[SnsTopicArn] = Optional.Absent,
    errorTopic: Optional[SnsTopicArn] = Optional.Absent,
    includeInferenceResponseIn: Optional[
      Iterable[zio.aws.sagemaker.model.AsyncNotificationTopicTypes]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig = {
    import AsyncInferenceNotificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
      .builder()
      .optionallyWith(
        successTopic.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.successTopic)
      .optionallyWith(
        errorTopic.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.errorTopic)
      .optionallyWith(
        includeInferenceResponseIn.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeInferenceResponseInWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceNotificationConfig
      .wrap(buildAwsValue())
}
object AsyncInferenceNotificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceNotificationConfig =
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig(
        successTopic.map(value => value),
        errorTopic.map(value => value),
        includeInferenceResponseIn.map(value => value)
      )
    def successTopic: Optional[SnsTopicArn]
    def errorTopic: Optional[SnsTopicArn]
    def includeInferenceResponseIn
        : Optional[List[zio.aws.sagemaker.model.AsyncNotificationTopicTypes]]
    def getSuccessTopic: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("successTopic", successTopic)
    def getErrorTopic: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("errorTopic", errorTopic)
    def getIncludeInferenceResponseIn: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AsyncNotificationTopicTypes
    ]] = AwsError.unwrapOptionField(
      "includeInferenceResponseIn",
      includeInferenceResponseIn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly {
    override val successTopic: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.successTopic())
      .map(value => zio.aws.sagemaker.model.primitives.SnsTopicArn(value))
    override val errorTopic: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.errorTopic())
      .map(value => zio.aws.sagemaker.model.primitives.SnsTopicArn(value))
    override val includeInferenceResponseIn
        : Optional[List[zio.aws.sagemaker.model.AsyncNotificationTopicTypes]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeInferenceResponseIn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AsyncNotificationTopicTypes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ): zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly =
    new Wrapper(impl)
}
