package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AdditionalS3DataSourceDataType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType
}
object AdditionalS3DataSourceDataType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType
  ): zio.aws.sagemaker.model.AdditionalS3DataSourceDataType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType.S3_OBJECT =>
      val r = S3Object
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AdditionalS3DataSourceDataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType =
      software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3Object
      extends zio.aws.sagemaker.model.AdditionalS3DataSourceDataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType =
      software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSourceDataType.S3_OBJECT
  }
}
