package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Dimension
import scala.jdk.CollectionConverters.*
final case class VectorConfig(dimension: Dimension) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.VectorConfig = {
    import VectorConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.VectorConfig
      .builder()
      .dimension(Dimension.unwrap(dimension): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.VectorConfig.ReadOnly =
    zio.aws.sagemaker.model.VectorConfig.wrap(buildAwsValue())
}
object VectorConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.VectorConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.VectorConfig =
      zio.aws.sagemaker.model.VectorConfig(dimension)
    def dimension: Dimension
    def getDimension: ZIO[Any, Nothing, Dimension] = ZIO.succeed(dimension)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.VectorConfig
  ) extends zio.aws.sagemaker.model.VectorConfig.ReadOnly {
    override val dimension: Dimension =
      zio.aws.sagemaker.model.primitives.Dimension(impl.dimension())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.VectorConfig
  ): zio.aws.sagemaker.model.VectorConfig.ReadOnly = new Wrapper(impl)
}
