package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ForecastQuantile,
  ForecastHorizon,
  ForecastFrequency,
  S3Uri
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TimeSeriesForecastingJobConfig(
    featureSpecificationS3Uri: Optional[S3Uri] = Optional.Absent,
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    forecastFrequency: ForecastFrequency,
    forecastHorizon: ForecastHorizon,
    forecastQuantiles: Optional[Iterable[ForecastQuantile]] = Optional.Absent,
    transformations: Optional[
      zio.aws.sagemaker.model.TimeSeriesTransformations
    ] = Optional.Absent,
    timeSeriesConfig: zio.aws.sagemaker.model.TimeSeriesConfig,
    holidayConfig: Optional[
      Iterable[zio.aws.sagemaker.model.HolidayConfigAttributes]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig = {
    import TimeSeriesForecastingJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig
      .builder()
      .optionallyWith(
        featureSpecificationS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.featureSpecificationS3Uri)
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .forecastFrequency(
        ForecastFrequency.unwrap(forecastFrequency): java.lang.String
      )
      .forecastHorizon(ForecastHorizon.unwrap(forecastHorizon): Integer)
      .optionallyWith(
        forecastQuantiles.map(value =>
          value.map { item =>
            ForecastQuantile.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastQuantiles)
      .optionallyWith(transformations.map(value => value.buildAwsValue()))(
        _.transformations
      )
      .timeSeriesConfig(timeSeriesConfig.buildAwsValue())
      .optionallyWith(
        holidayConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.holidayConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig.ReadOnly =
    zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig.wrap(buildAwsValue())
}
object TimeSeriesForecastingJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig =
      zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig(
        featureSpecificationS3Uri.map(value => value),
        completionCriteria.map(value => value.asEditable),
        forecastFrequency,
        forecastHorizon,
        forecastQuantiles.map(value => value),
        transformations.map(value => value.asEditable),
        timeSeriesConfig.asEditable,
        holidayConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureSpecificationS3Uri: Optional[S3Uri]
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def forecastFrequency: ForecastFrequency
    def forecastHorizon: ForecastHorizon
    def forecastQuantiles: Optional[List[ForecastQuantile]]
    def transformations
        : Optional[zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly]
    def timeSeriesConfig: zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly
    def holidayConfig: Optional[
      List[zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly]
    ]
    def getFeatureSpecificationS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("featureSpecificationS3Uri", featureSpecificationS3Uri)
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getForecastFrequency: ZIO[Any, Nothing, ForecastFrequency] =
      ZIO.succeed(forecastFrequency)
    def getForecastHorizon: ZIO[Any, Nothing, ForecastHorizon] =
      ZIO.succeed(forecastHorizon)
    def getForecastQuantiles: ZIO[Any, AwsError, List[ForecastQuantile]] =
      AwsError.unwrapOptionField("forecastQuantiles", forecastQuantiles)
    def getTransformations: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly
    ] = AwsError.unwrapOptionField("transformations", transformations)
    def getTimeSeriesConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly] =
      ZIO.succeed(timeSeriesConfig)
    def getHolidayConfig: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("holidayConfig", holidayConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig
  ) extends zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig.ReadOnly {
    override val featureSpecificationS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureSpecificationS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val forecastFrequency: ForecastFrequency =
      zio.aws.sagemaker.model.primitives
        .ForecastFrequency(impl.forecastFrequency())
    override val forecastHorizon: ForecastHorizon =
      zio.aws.sagemaker.model.primitives.ForecastHorizon(impl.forecastHorizon())
    override val forecastQuantiles: Optional[List[ForecastQuantile]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastQuantiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ForecastQuantile(item)
          }.toList
        )
    override val transformations
        : Optional[zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transformations())
        .map(value =>
          zio.aws.sagemaker.model.TimeSeriesTransformations.wrap(value)
        )
    override val timeSeriesConfig
        : zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly =
      zio.aws.sagemaker.model.TimeSeriesConfig.wrap(impl.timeSeriesConfig())
    override val holidayConfig: Optional[
      List[zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.holidayConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HolidayConfigAttributes.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig
  ): zio.aws.sagemaker.model.TimeSeriesForecastingJobConfig.ReadOnly =
    new Wrapper(impl)
}
