package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  GroupingAttributeName,
  ItemIdentifierAttributeName,
  TimestampAttributeName,
  TargetAttributeName
}
import scala.jdk.CollectionConverters.*
final case class TimeSeriesConfig(
    targetAttributeName: TargetAttributeName,
    timestampAttributeName: TimestampAttributeName,
    itemIdentifierAttributeName: ItemIdentifierAttributeName,
    groupingAttributeNames: Optional[Iterable[GroupingAttributeName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig = {
    import TimeSeriesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig
      .builder()
      .targetAttributeName(
        TargetAttributeName.unwrap(targetAttributeName): java.lang.String
      )
      .timestampAttributeName(
        TimestampAttributeName.unwrap(timestampAttributeName): java.lang.String
      )
      .itemIdentifierAttributeName(
        ItemIdentifierAttributeName.unwrap(
          itemIdentifierAttributeName
        ): java.lang.String
      )
      .optionallyWith(
        groupingAttributeNames.map(value =>
          value.map { item =>
            GroupingAttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupingAttributeNames)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly =
    zio.aws.sagemaker.model.TimeSeriesConfig.wrap(buildAwsValue())
}
object TimeSeriesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TimeSeriesConfig =
      zio.aws.sagemaker.model.TimeSeriesConfig(
        targetAttributeName,
        timestampAttributeName,
        itemIdentifierAttributeName,
        groupingAttributeNames.map(value => value)
      )
    def targetAttributeName: TargetAttributeName
    def timestampAttributeName: TimestampAttributeName
    def itemIdentifierAttributeName: ItemIdentifierAttributeName
    def groupingAttributeNames: Optional[List[GroupingAttributeName]]
    def getTargetAttributeName: ZIO[Any, Nothing, TargetAttributeName] =
      ZIO.succeed(targetAttributeName)
    def getTimestampAttributeName: ZIO[Any, Nothing, TimestampAttributeName] =
      ZIO.succeed(timestampAttributeName)
    def getItemIdentifierAttributeName
        : ZIO[Any, Nothing, ItemIdentifierAttributeName] =
      ZIO.succeed(itemIdentifierAttributeName)
    def getGroupingAttributeNames
        : ZIO[Any, AwsError, List[GroupingAttributeName]] = AwsError
      .unwrapOptionField("groupingAttributeNames", groupingAttributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig
  ) extends zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly {
    override val targetAttributeName: TargetAttributeName =
      zio.aws.sagemaker.model.primitives
        .TargetAttributeName(impl.targetAttributeName())
    override val timestampAttributeName: TimestampAttributeName =
      zio.aws.sagemaker.model.primitives
        .TimestampAttributeName(impl.timestampAttributeName())
    override val itemIdentifierAttributeName: ItemIdentifierAttributeName =
      zio.aws.sagemaker.model.primitives
        .ItemIdentifierAttributeName(impl.itemIdentifierAttributeName())
    override val groupingAttributeNames: Optional[List[GroupingAttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupingAttributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.GroupingAttributeName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig
  ): zio.aws.sagemaker.model.TimeSeriesConfig.ReadOnly = new Wrapper(impl)
}
