package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait StorageType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.StorageType
}
object StorageType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.StorageType
  ): zio.aws.sagemaker.model.StorageType = value match {
    case software.amazon.awssdk.services.sagemaker.model.StorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.StorageType.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.sagemaker.model.StorageType.IN_MEMORY =>
      val r = InMemory
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StorageType =
      software.amazon.awssdk.services.sagemaker.model.StorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.sagemaker.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StorageType =
      software.amazon.awssdk.services.sagemaker.model.StorageType.STANDARD
  }
  case object InMemory extends zio.aws.sagemaker.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StorageType =
      software.amazon.awssdk.services.sagemaker.model.StorageType.IN_MEMORY
  }
}
