package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait SkipModelValidation {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.SkipModelValidation
}
object SkipModelValidation {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SkipModelValidation
  ): zio.aws.sagemaker.model.SkipModelValidation = value match {
    case software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.SkipModelValidation {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SkipModelValidation =
      software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.sagemaker.model.SkipModelValidation {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SkipModelValidation =
      software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.ALL
  }
  case object None extends zio.aws.sagemaker.model.SkipModelValidation {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SkipModelValidation =
      software.amazon.awssdk.services.sagemaker.model.SkipModelValidation.NONE
  }
}
