package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class SearchResponse(
    results: Optional[Iterable[zio.aws.sagemaker.model.SearchRecord]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchResponse = {
    import SearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchResponse.ReadOnly =
    zio.aws.sagemaker.model.SearchResponse.wrap(buildAwsValue())
}
object SearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchResponse =
      zio.aws.sagemaker.model.SearchResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results: Optional[List[zio.aws.sagemaker.model.SearchRecord.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.SearchRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchResponse
  ) extends zio.aws.sagemaker.model.SearchResponse.ReadOnly {
    override val results
        : Optional[List[zio.aws.sagemaker.model.SearchRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.SearchRecord.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchResponse
  ): zio.aws.sagemaker.model.SearchResponse.ReadOnly = new Wrapper(impl)
}
