package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ScalingPolicyMetric(
    invocationsPerInstance: Optional[Integer] = Optional.Absent,
    modelLatency: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric = {
    import ScalingPolicyMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric
      .builder()
      .optionallyWith(
        invocationsPerInstance.map(value => value: java.lang.Integer)
      )(_.invocationsPerInstance)
      .optionallyWith(modelLatency.map(value => value: java.lang.Integer))(
        _.modelLatency
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly =
    zio.aws.sagemaker.model.ScalingPolicyMetric.wrap(buildAwsValue())
}
object ScalingPolicyMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ScalingPolicyMetric =
      zio.aws.sagemaker.model.ScalingPolicyMetric(
        invocationsPerInstance.map(value => value),
        modelLatency.map(value => value)
      )
    def invocationsPerInstance: Optional[Integer]
    def modelLatency: Optional[Integer]
    def getInvocationsPerInstance: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("invocationsPerInstance", invocationsPerInstance)
    def getModelLatency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelLatency", modelLatency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric
  ) extends zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly {
    override val invocationsPerInstance: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationsPerInstance())
        .map(value => value: Integer)
    override val modelLatency: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelLatency())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric
  ): zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly = new Wrapper(impl)
}
