package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScalingPolicy(
    targetTracking: Optional[
      zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ScalingPolicy = {
    import ScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicy
      .builder()
      .optionallyWith(targetTracking.map(value => value.buildAwsValue()))(
        _.targetTracking
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ScalingPolicy.ReadOnly =
    zio.aws.sagemaker.model.ScalingPolicy.wrap(buildAwsValue())
}
object ScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ScalingPolicy =
      zio.aws.sagemaker.model
        .ScalingPolicy(targetTracking.map(value => value.asEditable))
    def targetTracking: Optional[
      zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ]
    def getTargetTracking: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetTracking", targetTracking)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicy
  ) extends zio.aws.sagemaker.model.ScalingPolicy.ReadOnly {
    override val targetTracking: Optional[
      zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTracking())
      .map(value =>
        zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicy
  ): zio.aws.sagemaker.model.ScalingPolicy.ReadOnly = new Wrapper(impl)
}
