package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait S3ModelDataType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.S3ModelDataType
}
object S3ModelDataType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.S3ModelDataType
  ): zio.aws.sagemaker.model.S3ModelDataType = value match {
    case software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.S3_PREFIX =>
      val r = S3Prefix
      r
    case software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.S3_OBJECT =>
      val r = S3Object
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.S3ModelDataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3ModelDataType =
      software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3Prefix extends zio.aws.sagemaker.model.S3ModelDataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3ModelDataType =
      software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.S3_PREFIX
  }
  case object S3Object extends zio.aws.sagemaker.model.S3ModelDataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3ModelDataType =
      software.amazon.awssdk.services.sagemaker.model.S3ModelDataType.S3_OBJECT
  }
}
