package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaximumExecutionTimeoutInSeconds,
  WaitIntervalInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RollingUpdatePolicy(
    maximumBatchSize: zio.aws.sagemaker.model.CapacitySize,
    waitIntervalInSeconds: WaitIntervalInSeconds,
    maximumExecutionTimeoutInSeconds: Optional[
      MaximumExecutionTimeoutInSeconds
    ] = Optional.Absent,
    rollbackMaximumBatchSize: Optional[zio.aws.sagemaker.model.CapacitySize] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RollingUpdatePolicy = {
    import RollingUpdatePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RollingUpdatePolicy
      .builder()
      .maximumBatchSize(maximumBatchSize.buildAwsValue())
      .waitIntervalInSeconds(
        WaitIntervalInSeconds.unwrap(waitIntervalInSeconds): Integer
      )
      .optionallyWith(
        maximumExecutionTimeoutInSeconds.map(value =>
          MaximumExecutionTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.maximumExecutionTimeoutInSeconds)
      .optionallyWith(
        rollbackMaximumBatchSize.map(value => value.buildAwsValue())
      )(_.rollbackMaximumBatchSize)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly =
    zio.aws.sagemaker.model.RollingUpdatePolicy.wrap(buildAwsValue())
}
object RollingUpdatePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RollingUpdatePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RollingUpdatePolicy =
      zio.aws.sagemaker.model.RollingUpdatePolicy(
        maximumBatchSize.asEditable,
        waitIntervalInSeconds,
        maximumExecutionTimeoutInSeconds.map(value => value),
        rollbackMaximumBatchSize.map(value => value.asEditable)
      )
    def maximumBatchSize: zio.aws.sagemaker.model.CapacitySize.ReadOnly
    def waitIntervalInSeconds: WaitIntervalInSeconds
    def maximumExecutionTimeoutInSeconds
        : Optional[MaximumExecutionTimeoutInSeconds]
    def rollbackMaximumBatchSize
        : Optional[zio.aws.sagemaker.model.CapacitySize.ReadOnly]
    def getMaximumBatchSize
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CapacitySize.ReadOnly] =
      ZIO.succeed(maximumBatchSize)
    def getWaitIntervalInSeconds: ZIO[Any, Nothing, WaitIntervalInSeconds] =
      ZIO.succeed(waitIntervalInSeconds)
    def getMaximumExecutionTimeoutInSeconds
        : ZIO[Any, AwsError, MaximumExecutionTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "maximumExecutionTimeoutInSeconds",
        maximumExecutionTimeoutInSeconds
      )
    def getRollbackMaximumBatchSize
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CapacitySize.ReadOnly] =
      AwsError.unwrapOptionField(
        "rollbackMaximumBatchSize",
        rollbackMaximumBatchSize
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RollingUpdatePolicy
  ) extends zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly {
    override val maximumBatchSize
        : zio.aws.sagemaker.model.CapacitySize.ReadOnly =
      zio.aws.sagemaker.model.CapacitySize.wrap(impl.maximumBatchSize())
    override val waitIntervalInSeconds: WaitIntervalInSeconds =
      zio.aws.sagemaker.model.primitives
        .WaitIntervalInSeconds(impl.waitIntervalInSeconds())
    override val maximumExecutionTimeoutInSeconds
        : Optional[MaximumExecutionTimeoutInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumExecutionTimeoutInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaximumExecutionTimeoutInSeconds(value)
      )
    override val rollbackMaximumBatchSize
        : Optional[zio.aws.sagemaker.model.CapacitySize.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rollbackMaximumBatchSize())
        .map(value => zio.aws.sagemaker.model.CapacitySize.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RollingUpdatePolicy
  ): zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly = new Wrapper(impl)
}
