package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HyperParameterTuningMaxRuntimeInSeconds,
  MaxParallelTrainingJobs,
  MaxNumberOfTrainingJobs
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResourceLimits(
    maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs] =
      Optional.Absent,
    maxParallelTrainingJobs: MaxParallelTrainingJobs,
    maxRuntimeInSeconds: Optional[HyperParameterTuningMaxRuntimeInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceLimits = {
    import ResourceLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
      .builder()
      .optionallyWith(
        maxNumberOfTrainingJobs.map(value =>
          MaxNumberOfTrainingJobs.unwrap(value): Integer
        )
      )(_.maxNumberOfTrainingJobs)
      .maxParallelTrainingJobs(
        MaxParallelTrainingJobs.unwrap(maxParallelTrainingJobs): Integer
      )
      .optionallyWith(
        maxRuntimeInSeconds.map(value =>
          HyperParameterTuningMaxRuntimeInSeconds.unwrap(value): Integer
        )
      )(_.maxRuntimeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceLimits.ReadOnly =
    zio.aws.sagemaker.model.ResourceLimits.wrap(buildAwsValue())
}
object ResourceLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceLimits =
      zio.aws.sagemaker.model.ResourceLimits(
        maxNumberOfTrainingJobs.map(value => value),
        maxParallelTrainingJobs,
        maxRuntimeInSeconds.map(value => value)
      )
    def maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs]
    def maxParallelTrainingJobs: MaxParallelTrainingJobs
    def maxRuntimeInSeconds: Optional[HyperParameterTuningMaxRuntimeInSeconds]
    def getMaxNumberOfTrainingJobs
        : ZIO[Any, AwsError, MaxNumberOfTrainingJobs] = AwsError
      .unwrapOptionField("maxNumberOfTrainingJobs", maxNumberOfTrainingJobs)
    def getMaxParallelTrainingJobs: ZIO[Any, Nothing, MaxParallelTrainingJobs] =
      ZIO.succeed(maxParallelTrainingJobs)
    def getMaxRuntimeInSeconds
        : ZIO[Any, AwsError, HyperParameterTuningMaxRuntimeInSeconds] =
      AwsError.unwrapOptionField("maxRuntimeInSeconds", maxRuntimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ) extends zio.aws.sagemaker.model.ResourceLimits.ReadOnly {
    override val maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxNumberOfTrainingJobs())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxNumberOfTrainingJobs(value)
        )
    override val maxParallelTrainingJobs: MaxParallelTrainingJobs =
      zio.aws.sagemaker.model.primitives
        .MaxParallelTrainingJobs(impl.maxParallelTrainingJobs())
    override val maxRuntimeInSeconds
        : Optional[HyperParameterTuningMaxRuntimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuntimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .HyperParameterTuningMaxRuntimeInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ): zio.aws.sagemaker.model.ResourceLimits.ReadOnly = new Wrapper(impl)
}
