package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus
}
object RecommendationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecommendationStatus
  ): zio.aws.sagemaker.model.RecommendationStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.NOT_APPLICABLE =>
      val r = NOT_APPLICABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.sagemaker.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.sagemaker.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.COMPLETED
  }
  case object FAILED extends zio.aws.sagemaker.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.FAILED
  }
  case object NOT_APPLICABLE
      extends zio.aws.sagemaker.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStatus.NOT_APPLICABLE
  }
}
