package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TaskCount
import scala.jdk.CollectionConverters.*
final case class RealTimeInferenceConfig(
    instanceType: zio.aws.sagemaker.model.InstanceType,
    instanceCount: TaskCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig = {
    import RealTimeInferenceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig
      .builder()
      .instanceType(instanceType.unwrap)
      .instanceCount(TaskCount.unwrap(instanceCount): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly =
    zio.aws.sagemaker.model.RealTimeInferenceConfig.wrap(buildAwsValue())
}
object RealTimeInferenceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RealTimeInferenceConfig =
      zio.aws.sagemaker.model
        .RealTimeInferenceConfig(instanceType, instanceCount)
    def instanceType: zio.aws.sagemaker.model.InstanceType
    def instanceCount: TaskCount
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, TaskCount] =
      ZIO.succeed(instanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig
  ) extends zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly {
    override val instanceType: zio.aws.sagemaker.model.InstanceType =
      zio.aws.sagemaker.model.InstanceType.wrap(impl.instanceType())
    override val instanceCount: TaskCount =
      zio.aws.sagemaker.model.primitives.TaskCount(impl.instanceCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig
  ): zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly = new Wrapper(
    impl
  )
}
