package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{String1024, String256}
import scala.jdk.CollectionConverters.*
final case class QualityCheckStepMetadata(
    checkType: Optional[String256] = Optional.Absent,
    baselineUsedForDriftCheckStatistics: Optional[String1024] = Optional.Absent,
    baselineUsedForDriftCheckConstraints: Optional[String1024] =
      Optional.Absent,
    calculatedBaselineStatistics: Optional[String1024] = Optional.Absent,
    calculatedBaselineConstraints: Optional[String1024] = Optional.Absent,
    modelPackageGroupName: Optional[String256] = Optional.Absent,
    violationReport: Optional[String1024] = Optional.Absent,
    checkJobArn: Optional[String256] = Optional.Absent,
    skipCheck: Optional[Boolean] = Optional.Absent,
    registerNewBaseline: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata = {
    import QualityCheckStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata
      .builder()
      .optionallyWith(
        checkType.map(value => String256.unwrap(value): java.lang.String)
      )(_.checkType)
      .optionallyWith(
        baselineUsedForDriftCheckStatistics.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.baselineUsedForDriftCheckStatistics)
      .optionallyWith(
        baselineUsedForDriftCheckConstraints.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.baselineUsedForDriftCheckConstraints)
      .optionallyWith(
        calculatedBaselineStatistics.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.calculatedBaselineStatistics)
      .optionallyWith(
        calculatedBaselineConstraints.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.calculatedBaselineConstraints)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        violationReport.map(value => String1024.unwrap(value): java.lang.String)
      )(_.violationReport)
      .optionallyWith(
        checkJobArn.map(value => String256.unwrap(value): java.lang.String)
      )(_.checkJobArn)
      .optionallyWith(skipCheck.map(value => value: java.lang.Boolean))(
        _.skipCheck
      )
      .optionallyWith(
        registerNewBaseline.map(value => value: java.lang.Boolean)
      )(_.registerNewBaseline)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.QualityCheckStepMetadata.wrap(buildAwsValue())
}
object QualityCheckStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.QualityCheckStepMetadata =
      zio.aws.sagemaker.model.QualityCheckStepMetadata(
        checkType.map(value => value),
        baselineUsedForDriftCheckStatistics.map(value => value),
        baselineUsedForDriftCheckConstraints.map(value => value),
        calculatedBaselineStatistics.map(value => value),
        calculatedBaselineConstraints.map(value => value),
        modelPackageGroupName.map(value => value),
        violationReport.map(value => value),
        checkJobArn.map(value => value),
        skipCheck.map(value => value),
        registerNewBaseline.map(value => value)
      )
    def checkType: Optional[String256]
    def baselineUsedForDriftCheckStatistics: Optional[String1024]
    def baselineUsedForDriftCheckConstraints: Optional[String1024]
    def calculatedBaselineStatistics: Optional[String1024]
    def calculatedBaselineConstraints: Optional[String1024]
    def modelPackageGroupName: Optional[String256]
    def violationReport: Optional[String1024]
    def checkJobArn: Optional[String256]
    def skipCheck: Optional[Boolean]
    def registerNewBaseline: Optional[Boolean]
    def getCheckType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("checkType", checkType)
    def getBaselineUsedForDriftCheckStatistics: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField(
        "baselineUsedForDriftCheckStatistics",
        baselineUsedForDriftCheckStatistics
      )
    def getBaselineUsedForDriftCheckConstraints
        : ZIO[Any, AwsError, String1024] = AwsError.unwrapOptionField(
      "baselineUsedForDriftCheckConstraints",
      baselineUsedForDriftCheckConstraints
    )
    def getCalculatedBaselineStatistics: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField(
        "calculatedBaselineStatistics",
        calculatedBaselineStatistics
      )
    def getCalculatedBaselineConstraints: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField(
        "calculatedBaselineConstraints",
        calculatedBaselineConstraints
      )
    def getModelPackageGroupName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getViolationReport: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("violationReport", violationReport)
    def getCheckJobArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("checkJobArn", checkJobArn)
    def getSkipCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipCheck", skipCheck)
    def getRegisterNewBaseline: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("registerNewBaseline", registerNewBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata
  ) extends zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly {
    override val checkType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.checkType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val baselineUsedForDriftCheckStatistics: Optional[String1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineUsedForDriftCheckStatistics())
        .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val baselineUsedForDriftCheckConstraints: Optional[String1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineUsedForDriftCheckConstraints())
        .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val calculatedBaselineStatistics: Optional[String1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculatedBaselineStatistics())
        .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val calculatedBaselineConstraints: Optional[String1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculatedBaselineConstraints())
        .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val modelPackageGroupName: Optional[String256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupName())
        .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val violationReport: Optional[String1024] = zio.aws.core.internal
      .optionalFromNullable(impl.violationReport())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val checkJobArn: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.checkJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val skipCheck: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipCheck())
      .map(value => value: Boolean)
    override val registerNewBaseline: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.registerNewBaseline())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata
  ): zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
