package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParameterRanges(
    integerParameterRanges: Optional[
      Iterable[zio.aws.sagemaker.model.IntegerParameterRange]
    ] = Optional.Absent,
    continuousParameterRanges: Optional[
      Iterable[zio.aws.sagemaker.model.ContinuousParameterRange]
    ] = Optional.Absent,
    categoricalParameterRanges: Optional[
      Iterable[zio.aws.sagemaker.model.CategoricalParameterRange]
    ] = Optional.Absent,
    autoParameters: Optional[Iterable[zio.aws.sagemaker.model.AutoParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ParameterRanges = {
    import ParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ParameterRanges
      .builder()
      .optionallyWith(
        integerParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerParameterRanges)
      .optionallyWith(
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousParameterRanges)
      .optionallyWith(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalParameterRanges)
      .optionallyWith(
        autoParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ParameterRanges.ReadOnly =
    zio.aws.sagemaker.model.ParameterRanges.wrap(buildAwsValue())
}
object ParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ParameterRanges =
      zio.aws.sagemaker.model.ParameterRanges(
        integerParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerParameterRanges
        : Optional[List[zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly]]
    def continuousParameterRanges: Optional[
      List[zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly]
    ]
    def categoricalParameterRanges: Optional[
      List[zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly]
    ]
    def autoParameters
        : Optional[List[zio.aws.sagemaker.model.AutoParameter.ReadOnly]]
    def getIntegerParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerParameterRanges",
      integerParameterRanges
    )
    def getContinuousParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousParameterRanges",
      continuousParameterRanges
    )
    def getCategoricalParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalParameterRanges",
      categoricalParameterRanges
    )
    def getAutoParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("autoParameters", autoParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ) extends zio.aws.sagemaker.model.ParameterRanges.ReadOnly {
    override val integerParameterRanges: Optional[
      List[zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integerParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.IntegerParameterRange.wrap(item)
        }.toList
      )
    override val continuousParameterRanges: Optional[
      List[zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ContinuousParameterRange.wrap(item)
        }.toList
      )
    override val categoricalParameterRanges: Optional[
      List[zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.categoricalParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.CategoricalParameterRange.wrap(item)
        }.toList
      )
    override val autoParameters
        : Optional[List[zio.aws.sagemaker.model.AutoParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AutoParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ): zio.aws.sagemaker.model.ParameterRanges.ReadOnly = new Wrapper(impl)
}
