package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListNotebookInstancesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    notebookInstances: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse = {
    import ListNotebookInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        notebookInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notebookInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstancesResponse.wrap(buildAwsValue())
}
object ListNotebookInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListNotebookInstancesResponse =
      zio.aws.sagemaker.model.ListNotebookInstancesResponse(
        nextToken.map(value => value),
        notebookInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def notebookInstances: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNotebookInstances: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("notebookInstances", notebookInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse
  ) extends zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val notebookInstances: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse
  ): zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
