package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  AutoMLMaxResults,
  CandidateName,
  AutoMLJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCandidatesForAutoMlJobRequest(
    autoMLJobName: AutoMLJobName,
    statusEquals: Optional[zio.aws.sagemaker.model.CandidateStatus] =
      Optional.Absent,
    candidateNameEquals: Optional[CandidateName] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.CandidateSortBy] = Optional.Absent,
    maxResults: Optional[AutoMLMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest = {
    import ListCandidatesForAutoMlJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        candidateNameEquals.map(value =>
          CandidateName.unwrap(value): java.lang.String
        )
      )(_.candidateNameEquals)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => AutoMLMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly =
    zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest
      .wrap(buildAwsValue())
}
object ListCandidatesForAutoMlJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest =
      zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest(
        autoMLJobName,
        statusEquals.map(value => value),
        candidateNameEquals.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def autoMLJobName: AutoMLJobName
    def statusEquals: Optional[zio.aws.sagemaker.model.CandidateStatus]
    def candidateNameEquals: Optional[CandidateName]
    def sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.CandidateSortBy]
    def maxResults: Optional[AutoMLMaxResults]
    def nextToken: Optional[NextToken]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CandidateStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getCandidateNameEquals: ZIO[Any, AwsError, CandidateName] =
      AwsError.unwrapOptionField("candidateNameEquals", candidateNameEquals)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.CandidateSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, AutoMLMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ) extends zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.CandidateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.CandidateStatus.wrap(value))
    override val candidateNameEquals: Optional[CandidateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.candidateNameEquals())
        .map(value => zio.aws.sagemaker.model.primitives.CandidateName(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.AutoMLSortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.CandidateSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.CandidateSortBy.wrap(value))
    override val maxResults: Optional[AutoMLMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ): zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly =
    new Wrapper(impl)
}
