package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAppsResponse(
    apps: Optional[Iterable[zio.aws.sagemaker.model.AppDetails]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAppsResponse = {
    import ListAppsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAppsResponse
      .builder()
      .optionallyWith(
        apps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAppsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAppsResponse.wrap(buildAwsValue())
}
object ListAppsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAppsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAppsResponse =
      zio.aws.sagemaker.model.ListAppsResponse(
        apps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def apps: Optional[List[zio.aws.sagemaker.model.AppDetails.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApps: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AppDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("apps", apps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsResponse
  ) extends zio.aws.sagemaker.model.ListAppsResponse.ReadOnly {
    override val apps
        : Optional[List[zio.aws.sagemaker.model.AppDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AppDetails.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsResponse
  ): zio.aws.sagemaker.model.ListAppsResponse.ReadOnly = new Wrapper(impl)
}
