package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  Timestamp,
  HubContentVersion,
  HubContentName,
  HubContentArn,
  HubContentDescription,
  HubContentDisplayName,
  DocumentSchemaVersion
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HubContentInfo(
    hubContentName: HubContentName,
    hubContentArn: HubContentArn,
    hubContentVersion: HubContentVersion,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    documentSchemaVersion: DocumentSchemaVersion,
    hubContentDisplayName: Optional[HubContentDisplayName] = Optional.Absent,
    hubContentDescription: Optional[HubContentDescription] = Optional.Absent,
    hubContentSearchKeywords: Optional[Iterable[HubSearchKeyword]] =
      Optional.Absent,
    hubContentStatus: zio.aws.sagemaker.model.HubContentStatus,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HubContentInfo = {
    import HubContentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HubContentInfo
      .builder()
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .hubContentArn(HubContentArn.unwrap(hubContentArn): java.lang.String)
      .hubContentVersion(
        HubContentVersion.unwrap(hubContentVersion): java.lang.String
      )
      .hubContentType(hubContentType.unwrap)
      .documentSchemaVersion(
        DocumentSchemaVersion.unwrap(documentSchemaVersion): java.lang.String
      )
      .optionallyWith(
        hubContentDisplayName.map(value =>
          HubContentDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubContentDisplayName)
      .optionallyWith(
        hubContentDescription.map(value =>
          HubContentDescription.unwrap(value): java.lang.String
        )
      )(_.hubContentDescription)
      .optionallyWith(
        hubContentSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubContentSearchKeywords)
      .hubContentStatus(hubContentStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HubContentInfo.ReadOnly =
    zio.aws.sagemaker.model.HubContentInfo.wrap(buildAwsValue())
}
object HubContentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HubContentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HubContentInfo =
      zio.aws.sagemaker.model.HubContentInfo(
        hubContentName,
        hubContentArn,
        hubContentVersion,
        hubContentType,
        documentSchemaVersion,
        hubContentDisplayName.map(value => value),
        hubContentDescription.map(value => value),
        hubContentSearchKeywords.map(value => value),
        hubContentStatus,
        creationTime
      )
    def hubContentName: HubContentName
    def hubContentArn: HubContentArn
    def hubContentVersion: HubContentVersion
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def documentSchemaVersion: DocumentSchemaVersion
    def hubContentDisplayName: Optional[HubContentDisplayName]
    def hubContentDescription: Optional[HubContentDescription]
    def hubContentSearchKeywords: Optional[List[HubSearchKeyword]]
    def hubContentStatus: zio.aws.sagemaker.model.HubContentStatus
    def creationTime: Timestamp
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getHubContentArn: ZIO[Any, Nothing, HubContentArn] =
      ZIO.succeed(hubContentArn)
    def getHubContentVersion: ZIO[Any, Nothing, HubContentVersion] =
      ZIO.succeed(hubContentVersion)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getDocumentSchemaVersion: ZIO[Any, Nothing, DocumentSchemaVersion] =
      ZIO.succeed(documentSchemaVersion)
    def getHubContentDisplayName: ZIO[Any, AwsError, HubContentDisplayName] =
      AwsError.unwrapOptionField("hubContentDisplayName", hubContentDisplayName)
    def getHubContentDescription: ZIO[Any, AwsError, HubContentDescription] =
      AwsError.unwrapOptionField("hubContentDescription", hubContentDescription)
    def getHubContentSearchKeywords
        : ZIO[Any, AwsError, List[HubSearchKeyword]] = AwsError
      .unwrapOptionField("hubContentSearchKeywords", hubContentSearchKeywords)
    def getHubContentStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentStatus] =
      ZIO.succeed(hubContentStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HubContentInfo
  ) extends zio.aws.sagemaker.model.HubContentInfo.ReadOnly {
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val hubContentArn: HubContentArn =
      zio.aws.sagemaker.model.primitives.HubContentArn(impl.hubContentArn())
    override val hubContentVersion: HubContentVersion =
      zio.aws.sagemaker.model.primitives
        .HubContentVersion(impl.hubContentVersion())
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val documentSchemaVersion: DocumentSchemaVersion =
      zio.aws.sagemaker.model.primitives
        .DocumentSchemaVersion(impl.documentSchemaVersion())
    override val hubContentDisplayName: Optional[HubContentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDisplayName(value)
        )
    override val hubContentDescription: Optional[HubContentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDescription(value)
        )
    override val hubContentSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val hubContentStatus: zio.aws.sagemaker.model.HubContentStatus =
      zio.aws.sagemaker.model.HubContentStatus.wrap(impl.hubContentStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HubContentInfo
  ): zio.aws.sagemaker.model.HubContentInfo.ReadOnly = new Wrapper(impl)
}
