package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  UtilizationPercentagePerCore,
  EndpointName,
  RecommendationJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetScalingConfigurationRecommendationRequest(
    inferenceRecommendationsJobName: RecommendationJobName,
    recommendationId: Optional[String] = Optional.Absent,
    endpointName: Optional[EndpointName] = Optional.Absent,
    targetCpuUtilizationPerCore: Optional[UtilizationPercentagePerCore] =
      Optional.Absent,
    scalingPolicyObjective: Optional[
      zio.aws.sagemaker.model.ScalingPolicyObjective
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest = {
    import GetScalingConfigurationRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest
      .builder()
      .inferenceRecommendationsJobName(
        RecommendationJobName.unwrap(
          inferenceRecommendationsJobName
        ): java.lang.String
      )
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        targetCpuUtilizationPerCore.map(value =>
          UtilizationPercentagePerCore.unwrap(value): Integer
        )
      )(_.targetCpuUtilizationPerCore)
      .optionallyWith(
        scalingPolicyObjective.map(value => value.buildAwsValue())
      )(_.scalingPolicyObjective)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest.ReadOnly =
    zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest
      .wrap(buildAwsValue())
}
object GetScalingConfigurationRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest =
      zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest(
        inferenceRecommendationsJobName,
        recommendationId.map(value => value),
        endpointName.map(value => value),
        targetCpuUtilizationPerCore.map(value => value),
        scalingPolicyObjective.map(value => value.asEditable)
      )
    def inferenceRecommendationsJobName: RecommendationJobName
    def recommendationId: Optional[String]
    def endpointName: Optional[EndpointName]
    def targetCpuUtilizationPerCore: Optional[UtilizationPercentagePerCore]
    def scalingPolicyObjective
        : Optional[zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly]
    def getInferenceRecommendationsJobName
        : ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(inferenceRecommendationsJobName)
    def getRecommendationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getTargetCpuUtilizationPerCore
        : ZIO[Any, AwsError, UtilizationPercentagePerCore] =
      AwsError.unwrapOptionField(
        "targetCpuUtilizationPerCore",
        targetCpuUtilizationPerCore
      )
    def getScalingPolicyObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scalingPolicyObjective",
      scalingPolicyObjective
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest
  ) extends zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest.ReadOnly {
    override val inferenceRecommendationsJobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives
        .RecommendationJobName(impl.inferenceRecommendationsJobName())
    override val recommendationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationId())
      .map(value => value: String)
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val targetCpuUtilizationPerCore
        : Optional[UtilizationPercentagePerCore] = zio.aws.core.internal
      .optionalFromNullable(impl.targetCpuUtilizationPerCore())
      .map(value =>
        zio.aws.sagemaker.model.primitives.UtilizationPercentagePerCore(value)
      )
    override val scalingPolicyObjective
        : Optional[zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicyObjective())
        .map(value =>
          zio.aws.sagemaker.model.ScalingPolicyObjective.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest
  ): zio.aws.sagemaker.model.GetScalingConfigurationRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
