package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FillingType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FillingType
}
object FillingType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FillingType
  ): zio.aws.sagemaker.model.FillingType = value match {
    case software.amazon.awssdk.services.sagemaker.model.FillingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.FRONTFILL =>
      val r = frontfill
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.MIDDLEFILL =>
      val r = middlefill
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.BACKFILL =>
      val r = backfill
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.FUTUREFILL =>
      val r = futurefill
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.FRONTFILL_VALUE =>
      val r = frontfill_value
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.MIDDLEFILL_VALUE =>
      val r = middlefill_value
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.BACKFILL_VALUE =>
      val r = backfill_value
      r
    case software.amazon.awssdk.services.sagemaker.model.FillingType.FUTUREFILL_VALUE =>
      val r = futurefill_value
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.UNKNOWN_TO_SDK_VERSION
  }
  case object frontfill extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.FRONTFILL
  }
  case object middlefill extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.MIDDLEFILL
  }
  case object backfill extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.BACKFILL
  }
  case object futurefill extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.FUTUREFILL
  }
  case object frontfill_value extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.FRONTFILL_VALUE
  }
  case object middlefill_value extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.MIDDLEFILL_VALUE
  }
  case object backfill_value extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.BACKFILL_VALUE
  }
  case object futurefill_value extends zio.aws.sagemaker.model.FillingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FillingType =
      software.amazon.awssdk.services.sagemaker.model.FillingType.FUTUREFILL_VALUE
  }
}
