package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.InferenceSpecificationName
import scala.jdk.CollectionConverters.*
final case class EndpointInputConfiguration(
    instanceType: Optional[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = Optional.Absent,
    inferenceSpecificationName: Optional[InferenceSpecificationName] =
      Optional.Absent,
    environmentParameterRanges: Optional[
      zio.aws.sagemaker.model.EnvironmentParameterRanges
    ] = Optional.Absent,
    serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration = {
    import EndpointInputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        inferenceSpecificationName.map(value =>
          InferenceSpecificationName.unwrap(value): java.lang.String
        )
      )(_.inferenceSpecificationName)
      .optionallyWith(
        environmentParameterRanges.map(value => value.buildAwsValue())
      )(_.environmentParameterRanges)
      .optionallyWith(serverlessConfig.map(value => value.buildAwsValue()))(
        _.serverlessConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly =
    zio.aws.sagemaker.model.EndpointInputConfiguration.wrap(buildAwsValue())
}
object EndpointInputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointInputConfiguration =
      zio.aws.sagemaker.model.EndpointInputConfiguration(
        instanceType.map(value => value),
        inferenceSpecificationName.map(value => value),
        environmentParameterRanges.map(value => value.asEditable),
        serverlessConfig.map(value => value.asEditable)
      )
    def instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def inferenceSpecificationName: Optional[InferenceSpecificationName]
    def environmentParameterRanges
        : Optional[zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly]
    def serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInferenceSpecificationName
        : ZIO[Any, AwsError, InferenceSpecificationName] =
      AwsError.unwrapOptionField(
        "inferenceSpecificationName",
        inferenceSpecificationName
      )
    def getEnvironmentParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentParameterRanges",
      environmentParameterRanges
    )
    def getServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("serverlessConfig", serverlessConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ) extends zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly {
    override val instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
        )
    override val inferenceSpecificationName
        : Optional[InferenceSpecificationName] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSpecificationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InferenceSpecificationName(value)
      )
    override val environmentParameterRanges: Optional[
      zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentParameterRanges())
      .map(value =>
        zio.aws.sagemaker.model.EnvironmentParameterRanges.wrap(value)
      )
    override val serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ): zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
