package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  EdgeVersion,
  EntityName,
  EdgePackagingJobArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EdgePackagingJobSummary(
    edgePackagingJobArn: EdgePackagingJobArn,
    edgePackagingJobName: EntityName,
    edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus,
    compilationJobName: Optional[EntityName] = Optional.Absent,
    modelName: Optional[EntityName] = Optional.Absent,
    modelVersion: Optional[EdgeVersion] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary = {
    import EdgePackagingJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary
      .builder()
      .edgePackagingJobArn(
        EdgePackagingJobArn.unwrap(edgePackagingJobArn): java.lang.String
      )
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .edgePackagingJobStatus(edgePackagingJobStatus.unwrap)
      .optionallyWith(
        compilationJobName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.compilationJobName)
      .optionallyWith(
        modelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly =
    zio.aws.sagemaker.model.EdgePackagingJobSummary.wrap(buildAwsValue())
}
object EdgePackagingJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgePackagingJobSummary =
      zio.aws.sagemaker.model.EdgePackagingJobSummary(
        edgePackagingJobArn,
        edgePackagingJobName,
        edgePackagingJobStatus,
        compilationJobName.map(value => value),
        modelName.map(value => value),
        modelVersion.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def edgePackagingJobArn: EdgePackagingJobArn
    def edgePackagingJobName: EntityName
    def edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus
    def compilationJobName: Optional[EntityName]
    def modelName: Optional[EntityName]
    def modelVersion: Optional[EdgeVersion]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getEdgePackagingJobArn: ZIO[Any, Nothing, EdgePackagingJobArn] =
      ZIO.succeed(edgePackagingJobArn)
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
    def getEdgePackagingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgePackagingJobStatus] =
      ZIO.succeed(edgePackagingJobStatus)
    def getCompilationJobName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("compilationJobName", compilationJobName)
    def getModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary
  ) extends zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly {
    override val edgePackagingJobArn: EdgePackagingJobArn =
      zio.aws.sagemaker.model.primitives
        .EdgePackagingJobArn(impl.edgePackagingJobArn())
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
    override val edgePackagingJobStatus
        : zio.aws.sagemaker.model.EdgePackagingJobStatus =
      zio.aws.sagemaker.model.EdgePackagingJobStatus
        .wrap(impl.edgePackagingJobStatus())
    override val compilationJobName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compilationJobName())
        .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelVersion: Optional[EdgeVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary
  ): zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
