package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class DynamicScalingConfiguration(
    minCapacity: Optional[Integer] = Optional.Absent,
    maxCapacity: Optional[Integer] = Optional.Absent,
    scaleInCooldown: Optional[Integer] = Optional.Absent,
    scaleOutCooldown: Optional[Integer] = Optional.Absent,
    scalingPolicies: Optional[Iterable[zio.aws.sagemaker.model.ScalingPolicy]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration = {
    import DynamicScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration
      .builder()
      .optionallyWith(minCapacity.map(value => value: java.lang.Integer))(
        _.minCapacity
      )
      .optionallyWith(maxCapacity.map(value => value: java.lang.Integer))(
        _.maxCapacity
      )
      .optionallyWith(scaleInCooldown.map(value => value: java.lang.Integer))(
        _.scaleInCooldown
      )
      .optionallyWith(scaleOutCooldown.map(value => value: java.lang.Integer))(
        _.scaleOutCooldown
      )
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly =
    zio.aws.sagemaker.model.DynamicScalingConfiguration.wrap(buildAwsValue())
}
object DynamicScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DynamicScalingConfiguration =
      zio.aws.sagemaker.model.DynamicScalingConfiguration(
        minCapacity.map(value => value),
        maxCapacity.map(value => value),
        scaleInCooldown.map(value => value),
        scaleOutCooldown.map(value => value),
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def minCapacity: Optional[Integer]
    def maxCapacity: Optional[Integer]
    def scaleInCooldown: Optional[Integer]
    def scaleOutCooldown: Optional[Integer]
    def scalingPolicies
        : Optional[List[zio.aws.sagemaker.model.ScalingPolicy.ReadOnly]]
    def getMinCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getScaleInCooldown: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getScaleOutCooldown: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ScalingPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration
  ) extends zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly {
    override val minCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value => value: Integer)
    override val maxCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => value: Integer)
    override val scaleInCooldown: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleInCooldown())
      .map(value => value: Integer)
    override val scaleOutCooldown: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleOutCooldown())
      .map(value => value: Integer)
    override val scalingPolicies
        : Optional[List[zio.aws.sagemaker.model.ScalingPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ScalingPolicy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration
  ): zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
