package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{Integer, ModelCardNameOrArn}
import scala.jdk.CollectionConverters.*
final case class DescribeModelCardRequest(
    modelCardName: ModelCardNameOrArn,
    modelCardVersion: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest = {
    import DescribeModelCardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest
      .builder()
      .modelCardName(ModelCardNameOrArn.unwrap(modelCardName): java.lang.String)
      .optionallyWith(modelCardVersion.map(value => value: java.lang.Integer))(
        _.modelCardVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeModelCardRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelCardRequest.wrap(buildAwsValue())
}
object DescribeModelCardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelCardRequest =
      zio.aws.sagemaker.model.DescribeModelCardRequest(
        modelCardName,
        modelCardVersion.map(value => value)
      )
    def modelCardName: ModelCardNameOrArn
    def modelCardVersion: Optional[Integer]
    def getModelCardName: ZIO[Any, Nothing, ModelCardNameOrArn] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelCardVersion", modelCardVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest
  ) extends zio.aws.sagemaker.model.DescribeModelCardRequest.ReadOnly {
    override val modelCardName: ModelCardNameOrArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardNameOrArn(impl.modelCardName())
    override val modelCardVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardVersion())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest
  ): zio.aws.sagemaker.model.DescribeModelCardRequest.ReadOnly = new Wrapper(
    impl
  )
}
