package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters.*
final case class DescribeModelBiasJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest = {
    import DescribeModelBiasJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DescribeModelBiasJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DescribeModelBiasJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest
  ): zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
