package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  Timestamp,
  FailureReason,
  HubDescription,
  HubDisplayName,
  HubName,
  HubArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeHubResponse(
    hubName: HubName,
    hubArn: HubArn,
    hubDisplayName: Optional[HubDisplayName] = Optional.Absent,
    hubDescription: Optional[HubDescription] = Optional.Absent,
    hubSearchKeywords: Optional[Iterable[HubSearchKeyword]] = Optional.Absent,
    s3StorageConfig: Optional[zio.aws.sagemaker.model.HubS3StorageConfig] =
      Optional.Absent,
    hubStatus: zio.aws.sagemaker.model.HubStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse = {
    import DescribeHubResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .optionallyWith(
        hubDisplayName.map(value =>
          HubDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubDisplayName)
      .optionallyWith(
        hubDescription.map(value =>
          HubDescription.unwrap(value): java.lang.String
        )
      )(_.hubDescription)
      .optionallyWith(
        hubSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubSearchKeywords)
      .optionallyWith(s3StorageConfig.map(value => value.buildAwsValue()))(
        _.s3StorageConfig
      )
      .hubStatus(hubStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHubResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeHubResponse.wrap(buildAwsValue())
}
object DescribeHubResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHubResponse =
      zio.aws.sagemaker.model.DescribeHubResponse(
        hubName,
        hubArn,
        hubDisplayName.map(value => value),
        hubDescription.map(value => value),
        hubSearchKeywords.map(value => value),
        s3StorageConfig.map(value => value.asEditable),
        hubStatus,
        failureReason.map(value => value),
        creationTime,
        lastModifiedTime
      )
    def hubName: HubName
    def hubArn: HubArn
    def hubDisplayName: Optional[HubDisplayName]
    def hubDescription: Optional[HubDescription]
    def hubSearchKeywords: Optional[List[HubSearchKeyword]]
    def s3StorageConfig
        : Optional[zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly]
    def hubStatus: zio.aws.sagemaker.model.HubStatus
    def failureReason: Optional[FailureReason]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
    def getHubDisplayName: ZIO[Any, AwsError, HubDisplayName] =
      AwsError.unwrapOptionField("hubDisplayName", hubDisplayName)
    def getHubDescription: ZIO[Any, AwsError, HubDescription] =
      AwsError.unwrapOptionField("hubDescription", hubDescription)
    def getHubSearchKeywords: ZIO[Any, AwsError, List[HubSearchKeyword]] =
      AwsError.unwrapOptionField("hubSearchKeywords", hubSearchKeywords)
    def getS3StorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3StorageConfig", s3StorageConfig)
    def getHubStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.HubStatus] =
      ZIO.succeed(hubStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse
  ) extends zio.aws.sagemaker.model.DescribeHubResponse.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
    override val hubDisplayName: Optional[HubDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.HubDisplayName(value))
    override val hubDescription: Optional[HubDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDescription())
        .map(value => zio.aws.sagemaker.model.primitives.HubDescription(value))
    override val hubSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val s3StorageConfig
        : Optional[zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageConfig())
        .map(value => zio.aws.sagemaker.model.HubS3StorageConfig.wrap(value))
    override val hubStatus: zio.aws.sagemaker.model.HubStatus =
      zio.aws.sagemaker.model.HubStatus.wrap(impl.hubStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse
  ): zio.aws.sagemaker.model.DescribeHubResponse.ReadOnly = new Wrapper(impl)
}
