package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  HubContentVersion,
  HubContentName,
  HubName
}
import scala.jdk.CollectionConverters.*
final case class DescribeHubContentRequest(
    hubName: HubName,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    hubContentName: HubContentName,
    hubContentVersion: Optional[HubContentVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest = {
    import DescribeHubContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubContentType(hubContentType.unwrap)
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .optionallyWith(
        hubContentVersion.map(value =>
          HubContentVersion.unwrap(value): java.lang.String
        )
      )(_.hubContentVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHubContentRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeHubContentRequest.wrap(buildAwsValue())
}
object DescribeHubContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHubContentRequest =
      zio.aws.sagemaker.model.DescribeHubContentRequest(
        hubName,
        hubContentType,
        hubContentName,
        hubContentVersion.map(value => value)
      )
    def hubName: HubName
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def hubContentName: HubContentName
    def hubContentVersion: Optional[HubContentVersion]
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getHubContentVersion: ZIO[Any, AwsError, HubContentVersion] =
      AwsError.unwrapOptionField("hubContentVersion", hubContentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest
  ) extends zio.aws.sagemaker.model.DescribeHubContentRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val hubContentVersion: Optional[HubContentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest
  ): zio.aws.sagemaker.model.DescribeHubContentRequest.ReadOnly = new Wrapper(
    impl
  )
}
