package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class DescribeActionRequest(actionName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest = {
    import DescribeActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest
      .builder()
      .actionName(ExperimentEntityName.unwrap(actionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeActionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeActionRequest.wrap(buildAwsValue())
}
object DescribeActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeActionRequest =
      zio.aws.sagemaker.model.DescribeActionRequest(actionName)
    def actionName: ExperimentEntityName
    def getActionName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest
  ) extends zio.aws.sagemaker.model.DescribeActionRequest.ReadOnly {
    override val actionName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.actionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest
  ): zio.aws.sagemaker.model.DescribeActionRequest.ReadOnly = new Wrapper(impl)
}
