package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelName
import scala.jdk.CollectionConverters.*
final case class DeleteModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest = {
    import DeleteModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteModelRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelRequest.wrap(buildAwsValue())
}
object DeleteModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteModelRequest =
      zio.aws.sagemaker.model.DeleteModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest
  ) extends zio.aws.sagemaker.model.DeleteModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest
  ): zio.aws.sagemaker.model.DeleteModelRequest.ReadOnly = new Wrapper(impl)
}
