package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentName
import scala.jdk.CollectionConverters.*
final case class DeleteInferenceExperimentRequest(
    name: InferenceExperimentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest = {
    import DeleteInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteInferenceExperimentRequest
      .wrap(buildAwsValue())
}
object DeleteInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteInferenceExperimentRequest =
      zio.aws.sagemaker.model.DeleteInferenceExperimentRequest(name)
    def name: InferenceExperimentName
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.DeleteInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest
  ): zio.aws.sagemaker.model.DeleteInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
