package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HubName
import scala.jdk.CollectionConverters.*
final case class DeleteHubRequest(hubName: HubName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest = {
    import DeleteHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteHubRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteHubRequest.wrap(buildAwsValue())
}
object DeleteHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteHubRequest =
      zio.aws.sagemaker.model.DeleteHubRequest(hubName)
    def hubName: HubName
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest
  ) extends zio.aws.sagemaker.model.DeleteHubRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest
  ): zio.aws.sagemaker.model.DeleteHubRequest.ReadOnly = new Wrapper(impl)
}
