package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AssociationEntityArn
import scala.jdk.CollectionConverters.*
final case class DeleteAssociationRequest(
    sourceArn: AssociationEntityArn,
    destinationArn: AssociationEntityArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest = {
    import DeleteAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest
      .builder()
      .sourceArn(AssociationEntityArn.unwrap(sourceArn): java.lang.String)
      .destinationArn(
        AssociationEntityArn.unwrap(destinationArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteAssociationRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteAssociationRequest.wrap(buildAwsValue())
}
object DeleteAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteAssociationRequest =
      zio.aws.sagemaker.model
        .DeleteAssociationRequest(sourceArn, destinationArn)
    def sourceArn: AssociationEntityArn
    def destinationArn: AssociationEntityArn
    def getSourceArn: ZIO[Any, Nothing, AssociationEntityArn] =
      ZIO.succeed(sourceArn)
    def getDestinationArn: ZIO[Any, Nothing, AssociationEntityArn] =
      ZIO.succeed(destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest
  ) extends zio.aws.sagemaker.model.DeleteAssociationRequest.ReadOnly {
    override val sourceArn: AssociationEntityArn =
      zio.aws.sagemaker.model.primitives.AssociationEntityArn(impl.sourceArn())
    override val destinationArn: AssociationEntityArn =
      zio.aws.sagemaker.model.primitives
        .AssociationEntityArn(impl.destinationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest
  ): zio.aws.sagemaker.model.DeleteAssociationRequest.ReadOnly = new Wrapper(
    impl
  )
}
