package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class DeleteActionRequest(actionName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest = {
    import DeleteActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest
      .builder()
      .actionName(ExperimentEntityName.unwrap(actionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteActionRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteActionRequest.wrap(buildAwsValue())
}
object DeleteActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteActionRequest =
      zio.aws.sagemaker.model.DeleteActionRequest(actionName)
    def actionName: ExperimentEntityName
    def getActionName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest
  ) extends zio.aws.sagemaker.model.DeleteActionRequest.ReadOnly {
    override val actionName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.actionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest
  ): zio.aws.sagemaker.model.DeleteActionRequest.ReadOnly = new Wrapper(impl)
}
