package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceName {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.DataSourceName
}
object DataSourceName {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DataSourceName
  ): zio.aws.sagemaker.model.DataSourceName = value match {
    case software.amazon.awssdk.services.sagemaker.model.DataSourceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DataSourceName.SALESFORCE_GENIE =>
      val r = SalesforceGenie
      r
    case software.amazon.awssdk.services.sagemaker.model.DataSourceName.SNOWFLAKE =>
      val r = Snowflake
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DataSourceName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DataSourceName =
      software.amazon.awssdk.services.sagemaker.model.DataSourceName.UNKNOWN_TO_SDK_VERSION
  }
  case object SalesforceGenie extends zio.aws.sagemaker.model.DataSourceName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DataSourceName =
      software.amazon.awssdk.services.sagemaker.model.DataSourceName.SALESFORCE_GENIE
  }
  case object Snowflake extends zio.aws.sagemaker.model.DataSourceName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DataSourceName =
      software.amazon.awssdk.services.sagemaker.model.DataSourceName.SNOWFLAKE
  }
}
