package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomizedMetricSpecification(
    metricName: Optional[String] = Optional.Absent,
    namespace: Optional[String] = Optional.Absent,
    statistic: Optional[zio.aws.sagemaker.model.Statistic] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification = {
    import CustomizedMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification
      .builder()
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly =
    zio.aws.sagemaker.model.CustomizedMetricSpecification.wrap(buildAwsValue())
}
object CustomizedMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CustomizedMetricSpecification =
      zio.aws.sagemaker.model.CustomizedMetricSpecification(
        metricName.map(value => value),
        namespace.map(value => value),
        statistic.map(value => value)
      )
    def metricName: Optional[String]
    def namespace: Optional[String]
    def statistic: Optional[zio.aws.sagemaker.model.Statistic]
    def getMetricName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getStatistic: ZIO[Any, AwsError, zio.aws.sagemaker.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification
  ) extends zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly {
    override val metricName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => value: String)
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
    override val statistic: Optional[zio.aws.sagemaker.model.Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.sagemaker.model.Statistic.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification
  ): zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
