package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName
import scala.jdk.CollectionConverters.*
final case class CreateNotebookInstanceLifecycleConfigRequest(
    notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName,
    onCreate: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = Optional.Absent,
    onStart: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest = {
    import CreateNotebookInstanceLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest
      .builder()
      .notebookInstanceLifecycleConfigName(
        NotebookInstanceLifecycleConfigName.unwrap(
          notebookInstanceLifecycleConfigName
        ): java.lang.String
      )
      .optionallyWith(
        onCreate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onCreate)
      .optionallyWith(
        onStart.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onStart)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object CreateNotebookInstanceLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest =
      zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest(
        notebookInstanceLifecycleConfigName,
        onCreate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onStart.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
    def onCreate: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def onStart: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigName] =
      ZIO.succeed(notebookInstanceLifecycleConfigName)
    def getOnCreate: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onCreate", onCreate)
    def getOnStart: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onStart", onStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest.ReadOnly {
    override val notebookInstanceLifecycleConfigName
        : NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName(
        impl.notebookInstanceLifecycleConfigName()
      )
    override val onCreate: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onCreate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val onStart: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onStart())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest
  ): zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
