package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  RoleArn,
  EdgeVersion,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CreateEdgePackagingJobRequest(
    edgePackagingJobName: EntityName,
    compilationJobName: EntityName,
    modelName: EntityName,
    modelVersion: EdgeVersion,
    roleArn: RoleArn,
    outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig,
    resourceKey: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest = {
    import CreateEdgePackagingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest
      .builder()
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .modelName(EntityName.unwrap(modelName): java.lang.String)
      .modelVersion(EdgeVersion.unwrap(modelVersion): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        resourceKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.resourceKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateEdgePackagingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateEdgePackagingJobRequest.wrap(buildAwsValue())
}
object CreateEdgePackagingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEdgePackagingJobRequest =
      zio.aws.sagemaker.model.CreateEdgePackagingJobRequest(
        edgePackagingJobName,
        compilationJobName,
        modelName,
        modelVersion,
        roleArn,
        outputConfig.asEditable,
        resourceKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def edgePackagingJobName: EntityName
    def compilationJobName: EntityName
    def modelName: EntityName
    def modelVersion: EdgeVersion
    def roleArn: RoleArn
    def outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    def resourceKey: Optional[KmsKeyId]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
    def getModelName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, EdgeVersion] =
      ZIO.succeed(modelVersion)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getResourceKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("resourceKey", resourceKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest
  ) extends zio.aws.sagemaker.model.CreateEdgePackagingJobRequest.ReadOnly {
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
    override val modelName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelName())
    override val modelVersion: EdgeVersion =
      zio.aws.sagemaker.model.primitives.EdgeVersion(impl.modelVersion())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val outputConfig
        : zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.EdgeOutputConfig.wrap(impl.outputConfig())
    override val resourceKey: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest
  ): zio.aws.sagemaker.model.CreateEdgePackagingJobRequest.ReadOnly =
    new Wrapper(impl)
}
