package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ContextArn
import scala.jdk.CollectionConverters.*
final case class CreateContextResponse(
    contextArn: Optional[ContextArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateContextResponse = {
    import CreateContextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateContextResponse
      .builder()
      .optionallyWith(
        contextArn.map(value => ContextArn.unwrap(value): java.lang.String)
      )(_.contextArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateContextResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateContextResponse.wrap(buildAwsValue())
}
object CreateContextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateContextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateContextResponse =
      zio.aws.sagemaker.model
        .CreateContextResponse(contextArn.map(value => value))
    def contextArn: Optional[ContextArn]
    def getContextArn: ZIO[Any, AwsError, ContextArn] =
      AwsError.unwrapOptionField("contextArn", contextArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateContextResponse
  ) extends zio.aws.sagemaker.model.CreateContextResponse.ReadOnly {
    override val contextArn: Optional[ContextArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contextArn())
      .map(value => zio.aws.sagemaker.model.primitives.ContextArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateContextResponse
  ): zio.aws.sagemaker.model.CreateContextResponse.ReadOnly = new Wrapper(impl)
}
