package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  VersionedArnOrName,
  Url,
  EnvironmentKey,
  EnvironmentValue,
  InferenceSpecificationName,
  ContainerHostname,
  ContainerImage
}
import scala.jdk.CollectionConverters.*
final case class ContainerDefinition(
    containerHostname: Optional[ContainerHostname] = Optional.Absent,
    image: Optional[ContainerImage] = Optional.Absent,
    imageConfig: Optional[zio.aws.sagemaker.model.ImageConfig] =
      Optional.Absent,
    mode: Optional[zio.aws.sagemaker.model.ContainerMode] = Optional.Absent,
    modelDataUrl: Optional[Url] = Optional.Absent,
    environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      Optional.Absent,
    modelPackageName: Optional[VersionedArnOrName] = Optional.Absent,
    inferenceSpecificationName: Optional[InferenceSpecificationName] =
      Optional.Absent,
    multiModelConfig: Optional[zio.aws.sagemaker.model.MultiModelConfig] =
      Optional.Absent,
    modelDataSource: Optional[zio.aws.sagemaker.model.ModelDataSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ContainerDefinition = {
    import ContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
      .builder()
      .optionallyWith(
        containerHostname.map(value =>
          ContainerHostname.unwrap(value): java.lang.String
        )
      )(_.containerHostname)
      .optionallyWith(
        image.map(value => ContainerImage.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        modelDataUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.modelDataUrl)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (EnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(
        modelPackageName.map(value =>
          VersionedArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageName)
      .optionallyWith(
        inferenceSpecificationName.map(value =>
          InferenceSpecificationName.unwrap(value): java.lang.String
        )
      )(_.inferenceSpecificationName)
      .optionallyWith(multiModelConfig.map(value => value.buildAwsValue()))(
        _.multiModelConfig
      )
      .optionallyWith(modelDataSource.map(value => value.buildAwsValue()))(
        _.modelDataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ContainerDefinition.ReadOnly =
    zio.aws.sagemaker.model.ContainerDefinition.wrap(buildAwsValue())
}
object ContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ContainerDefinition =
      zio.aws.sagemaker.model.ContainerDefinition(
        containerHostname.map(value => value),
        image.map(value => value),
        imageConfig.map(value => value.asEditable),
        mode.map(value => value),
        modelDataUrl.map(value => value),
        environment.map(value => value),
        modelPackageName.map(value => value),
        inferenceSpecificationName.map(value => value),
        multiModelConfig.map(value => value.asEditable),
        modelDataSource.map(value => value.asEditable)
      )
    def containerHostname: Optional[ContainerHostname]
    def image: Optional[ContainerImage]
    def imageConfig: Optional[zio.aws.sagemaker.model.ImageConfig.ReadOnly]
    def mode: Optional[zio.aws.sagemaker.model.ContainerMode]
    def modelDataUrl: Optional[Url]
    def environment: Optional[Map[EnvironmentKey, EnvironmentValue]]
    def modelPackageName: Optional[VersionedArnOrName]
    def inferenceSpecificationName: Optional[InferenceSpecificationName]
    def multiModelConfig
        : Optional[zio.aws.sagemaker.model.MultiModelConfig.ReadOnly]
    def modelDataSource
        : Optional[zio.aws.sagemaker.model.ModelDataSource.ReadOnly]
    def getContainerHostname: ZIO[Any, AwsError, ContainerHostname] =
      AwsError.unwrapOptionField("containerHostname", containerHostname)
    def getImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("image", image)
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
    def getMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.ContainerMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getModelDataUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("modelDataUrl", modelDataUrl)
    def getEnvironment
        : ZIO[Any, AwsError, Map[EnvironmentKey, EnvironmentValue]] =
      AwsError.unwrapOptionField("environment", environment)
    def getModelPackageName: ZIO[Any, AwsError, VersionedArnOrName] =
      AwsError.unwrapOptionField("modelPackageName", modelPackageName)
    def getInferenceSpecificationName
        : ZIO[Any, AwsError, InferenceSpecificationName] =
      AwsError.unwrapOptionField(
        "inferenceSpecificationName",
        inferenceSpecificationName
      )
    def getMultiModelConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MultiModelConfig.ReadOnly
    ] = AwsError.unwrapOptionField("multiModelConfig", multiModelConfig)
    def getModelDataSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelDataSource.ReadOnly] =
      AwsError.unwrapOptionField("modelDataSource", modelDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ) extends zio.aws.sagemaker.model.ContainerDefinition.ReadOnly {
    override val containerHostname: Optional[ContainerHostname] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerHostname())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ContainerHostname(value)
        )
    override val image: Optional[ContainerImage] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val imageConfig
        : Optional[zio.aws.sagemaker.model.ImageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageConfig())
        .map(value => zio.aws.sagemaker.model.ImageConfig.wrap(value))
    override val mode: Optional[zio.aws.sagemaker.model.ContainerMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.sagemaker.model.ContainerMode.wrap(value))
    override val modelDataUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.modelDataUrl())
      .map(value => zio.aws.sagemaker.model.primitives.Url(value))
    override val environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.EnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.EnvironmentValue(value)
            })
            .toMap
        )
    override val modelPackageName: Optional[VersionedArnOrName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.VersionedArnOrName(value)
        )
    override val inferenceSpecificationName
        : Optional[InferenceSpecificationName] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSpecificationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InferenceSpecificationName(value)
      )
    override val multiModelConfig
        : Optional[zio.aws.sagemaker.model.MultiModelConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiModelConfig())
        .map(value => zio.aws.sagemaker.model.MultiModelConfig.wrap(value))
    override val modelDataSource
        : Optional[zio.aws.sagemaker.model.ModelDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDataSource())
        .map(value => zio.aws.sagemaker.model.ModelDataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ): zio.aws.sagemaker.model.ContainerDefinition.ReadOnly = new Wrapper(impl)
}
