package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollectionConfig(
    vectorConfig: Optional[zio.aws.sagemaker.model.VectorConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CollectionConfig = {
    import CollectionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CollectionConfig
      .builder()
      .optionallyWith(vectorConfig.map(value => value.buildAwsValue()))(
        _.vectorConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CollectionConfig.ReadOnly =
    zio.aws.sagemaker.model.CollectionConfig.wrap(buildAwsValue())
}
object CollectionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CollectionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CollectionConfig =
      zio.aws.sagemaker.model
        .CollectionConfig(vectorConfig.map(value => value.asEditable))
    def vectorConfig: Optional[zio.aws.sagemaker.model.VectorConfig.ReadOnly]
    def getVectorConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VectorConfig.ReadOnly] =
      AwsError.unwrapOptionField("vectorConfig", vectorConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CollectionConfig
  ) extends zio.aws.sagemaker.model.CollectionConfig.ReadOnly {
    override val vectorConfig
        : Optional[zio.aws.sagemaker.model.VectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vectorConfig())
        .map(value => zio.aws.sagemaker.model.VectorConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CollectionConfig
  ): zio.aws.sagemaker.model.CollectionConfig.ReadOnly = new Wrapper(impl)
}
