package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  ClientId,
  CognitoUserGroup,
  CognitoUserPool
}
import scala.jdk.CollectionConverters.*
final case class CognitoMemberDefinition(
    userPool: CognitoUserPool,
    userGroup: CognitoUserGroup,
    clientId: ClientId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition = {
    import CognitoMemberDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition
      .builder()
      .userPool(CognitoUserPool.unwrap(userPool): java.lang.String)
      .userGroup(CognitoUserGroup.unwrap(userGroup): java.lang.String)
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly =
    zio.aws.sagemaker.model.CognitoMemberDefinition.wrap(buildAwsValue())
}
object CognitoMemberDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CognitoMemberDefinition =
      zio.aws.sagemaker.model
        .CognitoMemberDefinition(userPool, userGroup, clientId)
    def userPool: CognitoUserPool
    def userGroup: CognitoUserGroup
    def clientId: ClientId
    def getUserPool: ZIO[Any, Nothing, CognitoUserPool] = ZIO.succeed(userPool)
    def getUserGroup: ZIO[Any, Nothing, CognitoUserGroup] =
      ZIO.succeed(userGroup)
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition
  ) extends zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly {
    override val userPool: CognitoUserPool =
      zio.aws.sagemaker.model.primitives.CognitoUserPool(impl.userPool())
    override val userGroup: CognitoUserGroup =
      zio.aws.sagemaker.model.primitives.CognitoUserGroup(impl.userGroup())
    override val clientId: ClientId =
      zio.aws.sagemaker.model.primitives.ClientId(impl.clientId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition
  ): zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly = new Wrapper(
    impl
  )
}
