package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanvasAppSettings(
    timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings
    ] = Optional.Absent,
    modelRegisterSettings: Optional[
      zio.aws.sagemaker.model.ModelRegisterSettings
    ] = Optional.Absent,
    workspaceSettings: Optional[zio.aws.sagemaker.model.WorkspaceSettings] =
      Optional.Absent,
    identityProviderOAuthSettings: Optional[
      Iterable[zio.aws.sagemaker.model.IdentityProviderOAuthSetting]
    ] = Optional.Absent,
    kendraSettings: Optional[zio.aws.sagemaker.model.KendraSettings] =
      Optional.Absent,
    directDeploySettings: Optional[
      zio.aws.sagemaker.model.DirectDeploySettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings = {
    import CanvasAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
      .builder()
      .optionallyWith(
        timeSeriesForecastingSettings.map(value => value.buildAwsValue())
      )(_.timeSeriesForecastingSettings)
      .optionallyWith(
        modelRegisterSettings.map(value => value.buildAwsValue())
      )(_.modelRegisterSettings)
      .optionallyWith(workspaceSettings.map(value => value.buildAwsValue()))(
        _.workspaceSettings
      )
      .optionallyWith(
        identityProviderOAuthSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityProviderOAuthSettings)
      .optionallyWith(kendraSettings.map(value => value.buildAwsValue()))(
        _.kendraSettings
      )
      .optionallyWith(directDeploySettings.map(value => value.buildAwsValue()))(
        _.directDeploySettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly =
    zio.aws.sagemaker.model.CanvasAppSettings.wrap(buildAwsValue())
}
object CanvasAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CanvasAppSettings =
      zio.aws.sagemaker.model.CanvasAppSettings(
        timeSeriesForecastingSettings.map(value => value.asEditable),
        modelRegisterSettings.map(value => value.asEditable),
        workspaceSettings.map(value => value.asEditable),
        identityProviderOAuthSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kendraSettings.map(value => value.asEditable),
        directDeploySettings.map(value => value.asEditable)
      )
    def timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ]
    def modelRegisterSettings
        : Optional[zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly]
    def workspaceSettings
        : Optional[zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly]
    def identityProviderOAuthSettings: Optional[
      List[zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly]
    ]
    def kendraSettings
        : Optional[zio.aws.sagemaker.model.KendraSettings.ReadOnly]
    def directDeploySettings
        : Optional[zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly]
    def getTimeSeriesForecastingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesForecastingSettings",
      timeSeriesForecastingSettings
    )
    def getModelRegisterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("modelRegisterSettings", modelRegisterSettings)
    def getWorkspaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("workspaceSettings", workspaceSettings)
    def getIdentityProviderOAuthSettings: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "identityProviderOAuthSettings",
      identityProviderOAuthSettings
    )
    def getKendraSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.KendraSettings.ReadOnly] =
      AwsError.unwrapOptionField("kendraSettings", kendraSettings)
    def getDirectDeploySettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly
    ] = AwsError.unwrapOptionField("directDeploySettings", directDeploySettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ) extends zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly {
    override val timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesForecastingSettings())
      .map(value =>
        zio.aws.sagemaker.model.TimeSeriesForecastingSettings.wrap(value)
      )
    override val modelRegisterSettings
        : Optional[zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelRegisterSettings())
        .map(value => zio.aws.sagemaker.model.ModelRegisterSettings.wrap(value))
    override val workspaceSettings
        : Optional[zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceSettings())
        .map(value => zio.aws.sagemaker.model.WorkspaceSettings.wrap(value))
    override val identityProviderOAuthSettings: Optional[
      List[zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.identityProviderOAuthSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.IdentityProviderOAuthSetting.wrap(item)
        }.toList
      )
    override val kendraSettings
        : Optional[zio.aws.sagemaker.model.KendraSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kendraSettings())
        .map(value => zio.aws.sagemaker.model.KendraSettings.wrap(value))
    override val directDeploySettings
        : Optional[zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directDeploySettings())
        .map(value => zio.aws.sagemaker.model.DirectDeploySettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ): zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly = new Wrapper(impl)
}
