package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.MaxNumberOfTrainingJobsNotImproving
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BestObjectiveNotImproving(
    maxNumberOfTrainingJobsNotImproving: Optional[
      MaxNumberOfTrainingJobsNotImproving
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving = {
    import BestObjectiveNotImproving.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving
      .builder()
      .optionallyWith(
        maxNumberOfTrainingJobsNotImproving.map(value =>
          MaxNumberOfTrainingJobsNotImproving.unwrap(value): Integer
        )
      )(_.maxNumberOfTrainingJobsNotImproving)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly =
    zio.aws.sagemaker.model.BestObjectiveNotImproving.wrap(buildAwsValue())
}
object BestObjectiveNotImproving {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BestObjectiveNotImproving =
      zio.aws.sagemaker.model.BestObjectiveNotImproving(
        maxNumberOfTrainingJobsNotImproving.map(value => value)
      )
    def maxNumberOfTrainingJobsNotImproving
        : Optional[MaxNumberOfTrainingJobsNotImproving]
    def getMaxNumberOfTrainingJobsNotImproving
        : ZIO[Any, AwsError, MaxNumberOfTrainingJobsNotImproving] =
      AwsError.unwrapOptionField(
        "maxNumberOfTrainingJobsNotImproving",
        maxNumberOfTrainingJobsNotImproving
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving
  ) extends zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly {
    override val maxNumberOfTrainingJobsNotImproving
        : Optional[MaxNumberOfTrainingJobsNotImproving] = zio.aws.core.internal
      .optionalFromNullable(impl.maxNumberOfTrainingJobsNotImproving())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxNumberOfTrainingJobsNotImproving(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving
  ): zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly = new Wrapper(
    impl
  )
}
