package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutotuneMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutotuneMode
}
object AutotuneMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutotuneMode
  ): zio.aws.sagemaker.model.AutotuneMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutotuneMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutotuneMode.ENABLED =>
      val r = Enabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AutotuneMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutotuneMode =
      software.amazon.awssdk.services.sagemaker.model.AutotuneMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.sagemaker.model.AutotuneMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutotuneMode =
      software.amazon.awssdk.services.sagemaker.model.AutotuneMode.ENABLED
  }
}
